#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>
#include <limits>

using namespace std;

struct Mast {
    double x, h;
};

double rastojanje(double x0, double y0, double xl, double xr, double a, double b, double H, bool left) {
    if (left) {
        double x_max = min(xr, a - H);
        if (xl > x_max) return numeric_limits<double>::infinity();
        double x_star = (x0 + a - y0) / 2.0;
        if (x_star < xl) x_star = xl;
        else if (x_star > x_max) x_star = x_max;
        double y_star = a - x_star;
        return hypot(x_star - x0, y_star - y0);
    } else {
        double x_min = max(xl, H - b);
        if (x_min > xr) return numeric_limits<double>::infinity();
        double x_star = (x0 + y0 - b) / 2.0;
        if (x_star < x_min) x_star = x_min;
        else if (x_star > xr) x_star = xr;
        double y_star = b + x_star;
        return hypot(x_star - x0, y_star - y0);
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;
    vector<Mast> masts(n);
    for (int i = 0; i < n; ++i) {
        cin >> masts[i].x;
    }
    for (int i = 0; i < n; ++i) {
        cin >> masts[i].h;
    }

    sort(masts.begin(), masts.end(), [](const Mast& a, const Mast& b) {
        return a.x < b.x;
    });

    for (int i = 0; i < n; ++i) {
        double ans = numeric_limits<double>::infinity();

        for (int j = 0; j < n; ++j) {
            if (i == j) continue;
            if (masts[j].h >= masts[i].h) {
                double d = fabs(masts[i].x - masts[j].x);
                if (d < ans) ans = d;
            }
        }

        for (int k = 0; k < n - 1; ++k) {
            double xL = masts[k].x, hL = masts[k].h;
            double xR = masts[k+1].x, hR = masts[k+1].h;
            double t = (hL - hR + xL + xR) / 2.0;
            double y_min = (hL + hR - (xR - xL)) / 2.0;

            double d_left = rastojanje(masts[i].x, masts[i].h, xL, t, hL + xL, 0, masts[i].h, true);
            double d_right = rastojanje(masts[i].x, masts[i].h, t, xR, 0, hR - xR, masts[i].h, false);

            double d = min(d_left, d_right);
            if (d < ans) ans = d;
        }

        if (ans == numeric_limits<double>::infinity()) {
            cout << "-1\n";
        } else {
            cout << (long long)round(ans) << '\n';
        }
    }

    return 0;
}